/*
 * Decompiled with CFR 0.152.
 */
package com.inprise.vbroker.compiler.backends.idl;

import com.inprise.vbroker.compiler.ast.AliasNode;
import com.inprise.vbroker.compiler.ast.ArrayNode;
import com.inprise.vbroker.compiler.ast.AttributeNode;
import com.inprise.vbroker.compiler.ast.ConstantNode;
import com.inprise.vbroker.compiler.ast.ContainedNode;
import com.inprise.vbroker.compiler.ast.ContainerNode;
import com.inprise.vbroker.compiler.ast.EnumNode;
import com.inprise.vbroker.compiler.ast.ExceptionNode;
import com.inprise.vbroker.compiler.ast.FieldNode;
import com.inprise.vbroker.compiler.ast.InterfaceNode;
import com.inprise.vbroker.compiler.ast.ModuleNode;
import com.inprise.vbroker.compiler.ast.NativeNode;
import com.inprise.vbroker.compiler.ast.Node;
import com.inprise.vbroker.compiler.ast.NodeFactory;
import com.inprise.vbroker.compiler.ast.OperationNode;
import com.inprise.vbroker.compiler.ast.PrimitiveNode;
import com.inprise.vbroker.compiler.ast.SequenceNode;
import com.inprise.vbroker.compiler.ast.StructNode;
import com.inprise.vbroker.compiler.ast.Type;
import com.inprise.vbroker.compiler.ast.UnionNode;
import com.inprise.vbroker.compiler.ast.ValueBoxNode;
import com.inprise.vbroker.compiler.ast.ValueMemberNode;
import com.inprise.vbroker.compiler.ast.ValueNode;
import com.inprise.vbroker.compiler.backends.common.GenericBackend;
import com.inprise.vbroker.compiler.backends.idl.IdlDependencySpec;
import com.inprise.vbroker.compiler.backends.idl.ast.IdlBeOptions;
import com.inprise.vbroker.compiler.backends.idl.ast.IdlNodeFactory;
import com.inprise.vbroker.compiler.util.BufferWriter;
import com.inprise.vbroker.compiler.util.ErrorReporter;
import com.inprise.vbroker.util.SimpleStringBuffer;
import com.inprise.vbroker.util.StringFunctions;
import java.util.Enumeration;
import java.util.Hashtable;
import java.util.Stack;
import java.util.StringTokenizer;
import java.util.Vector;

public final class IdlBackend
extends GenericBackend {
    public boolean _forComments = false;
    public boolean OutputAsHTML = false;
    private SimpleStringBuffer AnnotationText = new SimpleStringBuffer();
    private SimpleStringBuffer _buf = new SimpleStringBuffer();
    private Hashtable typesSeen = new Hashtable();
    private IdlBeOptions _options;
    private Vector _prefixStack = new Vector();
    private Vector _defaultPrefixStack = new Vector();
    private Stack _modulePragmaVersionStack = new Stack();

    public IdlBackend() {
        super(null, new IdlDependencySpec(), "", null);
    }

    public IdlBackend(ContainerNode container, BufferWriter bufferWriter, String rootFile, Vector topLevelInclFiles) {
        super(((Node)((Object)container))._repository, new IdlDependencySpec(), rootFile, null);
        this._options = (IdlBeOptions)this._repository._options;
        this._prefixStack.addElement("");
        this._defaultPrefixStack.addElement("");
        this.generate(container);
        bufferWriter.write(this._options._outputFile, this.Buffer, true, null, true);
    }

    protected void beginModule(ModuleNode module) {
        this.openModule(module);
    }

    protected void closeModule(ModuleNode module) {
        --this.Indent;
        this.println("};\n");
        if (!this._forComments) {
            this.prefixPop();
            String pragmasAfter = (String)this._modulePragmaVersionStack.pop();
            if (pragmasAfter != null) {
                this.println(pragmasAfter);
            }
        }
    }

    private String defaultPrefix() {
        String s = (String)this._defaultPrefixStack.elementAt(0);
        return s.equals("") ? s : String.valueOf(s).concat("/");
    }

    protected void dispatch(ContainedNode node, String declarator) {
        boolean isContainer = node.isContainer();
        String pragmasAfter = null;
        pragmasAfter = this.maybeOutputPragmas(node);
        if (isContainer) {
            this.prefixPush(node._beName);
        }
        super.dispatch(node, declarator);
        if (pragmasAfter != null) {
            this.ensureNewLine();
            this.println(pragmasAfter);
        }
        if (isContainer) {
            this.prefixPop();
        }
    }

    protected void endModule(ModuleNode module) {
        this.printAnnotations(module, null);
        this.closeModule(module);
    }

    private final String expandAnnotations(Hashtable hints) {
        this.AnnotationText.reset();
        Enumeration e = hints.keys();
        while (e.hasMoreElements()) {
            String name = (String)e.nextElement();
            String value = (String)hints.get(name);
            this.AnnotationText.append(name);
            this.AnnotationText.append("=\"");
            this.AnnotationText.append(StringFunctions.ISOLatin1StringToPrintable(value, false));
            this.AnnotationText.append('\"');
            if (!e.hasMoreElements()) continue;
            this.AnnotationText.append(", ");
        }
        return this.AnnotationText.toString();
    }

    protected void forwardDeclareInterface(InterfaceNode intrface) {
        String name = intrface._beName;
        String pragmasAfter = null;
        pragmasAfter = this.maybeOutputPragmas(intrface);
        this.print("interface ");
        this.add(name);
        this.addln(";");
        this.printStylePragmas(intrface, true);
        this.printAnnotations(intrface, intrface._beFullName);
        if (pragmasAfter != null) {
            this.println(pragmasAfter);
        }
    }

    protected void forwardDeclareValue(ValueNode value) {
        String name = value._beName;
        String pragmasAfter = null;
        pragmasAfter = this.maybeOutputPragmas(value);
        this.print("valuetype ");
        this.add(name);
        this.addln(";");
        this.printStylePragmas(value, true);
        this.printAnnotations(value, value._beFullName);
        if (pragmasAfter != null) {
            this.println(pragmasAfter);
        }
    }

    protected void genAlias(AliasNode alias) {
        this.genUserComments(alias);
        this.print("typedef ");
        this.genType(alias._type, alias._beName);
        this.addln(";");
        this.printAnnotations(alias, alias._beFullName);
    }

    protected void genAttribute(AttributeNode attribute) {
        this.genUserComments(attribute);
        if (attribute._readOnly) {
            this.print("readonly attribute ");
        } else {
            this.print("attribute ");
        }
        this.genType(attribute._type, attribute._beName);
        this.addln(";");
        this.printOriginalName(attribute, true);
        this.printOriginalName(attribute, false);
        this.printAnnotations(attribute, attribute._beFullName);
    }

    protected void genConstant(ConstantNode constant) {
        this.genUserComments(constant);
        this.print("const ");
        this.genType(constant._type, constant._beName);
        this.add(" = ");
        this.add(constant._type.toLiteral(constant._value));
        this.addln(";");
        this.printAnnotations(constant, constant._beFullName);
    }

    protected void genEnum(EnumNode enumNode, String declarator) {
        this.genUserComments(enumNode);
        this.print("enum ");
        this.add(enumNode._beName);
        this.add(" {");
        this.commaSepList(enumNode, enumNode._memberNames);
        this.printAnnotations(enumNode, null);
        this.ensureIndent();
        if (declarator == null) {
            this.addln("};");
        } else {
            this.add("}");
            if (declarator.length() > 0) {
                this.add(" ");
            }
            this.add(declarator);
        }
    }

    protected void genException(ExceptionNode exception) {
        this.genUserComments(exception);
        this.print("exception ");
        this.add(exception._beName);
        this.addln(" {");
        ++this.Indent;
        this.printOriginalName(exception, true);
        if (this._forComments) {
            this.println("...");
        } else {
            Vector memberNames = exception._memberNames;
            Vector memberTypes = exception._memberTypes;
            int len = memberNames.size();
            for (int i = 0; i < len; ++i) {
                this.genMember(exception, (Type)memberTypes.elementAt(i), exception._repository._mapper.mapIdentifier((String)memberNames.elementAt(i)));
            }
        }
        this.printAnnotations(exception, null);
        --this.Indent;
        this.println("};");
    }

    protected void genInterface(InterfaceNode intrface) {
        this.genUserComments(intrface);
        if (!intrface._defined) {
            this.forwardDeclareInterface(intrface);
            return;
        }
        if (intrface._abstract) {
            this.print("abstract ");
        }
        this.print("interface ");
        this.add(intrface._beName);
        int len = intrface._bases.size();
        if (len > 0) {
            this.add(" : ");
            this.commaSepDefs(intrface._bases, true);
        }
        this.addln(" {");
        ++this.Indent;
        this.printStylePragmas(intrface, false);
        if (this._forComments) {
            this.println("...");
        } else {
            this.genContents(intrface);
        }
        this.printAnnotations(intrface, null);
        --this.Indent;
        this.println("};");
    }

    private void genMember(ContainerNode container, Type type, String name) {
        Node base = (Node)((Object)type);
        while (base._kind == 16 || base._kind == 15) {
            switch (base._kind) {
                case 16: {
                    base = (Node)((Object)((ArrayNode)base)._type);
                    break;
                }
                case 15: {
                    base = (Node)((Object)((SequenceNode)base)._type);
                }
            }
        }
        try {
            if (base.isContained() && ((ContainedNode)base)._container == container) {
                if (this.typesSeen.get(base) == Boolean.TRUE) {
                    this.genType(type, name, false, true);
                    this.addln(";");
                } else {
                    this.genType(type, name, true, true);
                    this.addln(";");
                    this.typesSeen.put(base, Boolean.TRUE);
                }
            } else {
                this.print("");
                this.genType(type, name);
                this.addln(";");
            }
        }
        catch (Throwable t) {
            t.printStackTrace();
        }
    }

    protected void genNative(NativeNode nativ) {
        this.genUserComments(nativ);
        this.print("native ");
        this.add(nativ._beName);
        this.addln(";");
        this.printAnnotations(nativ, nativ._beFullName);
    }

    protected void genOperation(OperationNode operation) {
        int i;
        this.genUserComments(operation);
        if (operation._oneWay) {
            this.print("oneway ");
        } else {
            this.print("");
        }
        this.genType(operation._result, operation._beName);
        this.add(" (");
        Vector paramNames = operation._paramNames;
        Vector paramTypes = operation._paramTypes;
        Vector paramModes = operation._paramModes;
        Vector contexts = operation._contexts;
        int savedPos = this._horizPos;
        this.beginLineBreaking();
        for (i = 0; i < paramNames.size(); ++i) {
            if (paramModes.elementAt(i) == OperationNode.PARAM_IN) {
                this.add("in ");
            } else if (paramModes.elementAt(i) == OperationNode.PARAM_OUT) {
                this.add("out ");
            } else {
                this.add("inout ");
            }
            this.genType((Type)paramTypes.elementAt(i), operation._repository._mapper.mapIdentifier((String)paramNames.elementAt(i)));
            if (i >= paramNames.size() - 1) continue;
            this.add(", ");
        }
        this.endLineBreaking();
        if (operation._exceptions.size() > 0) {
            this.addln(")");
            ++this.Indent;
            this.print("raises (");
            this.commaSepDefs(operation._exceptions, true);
            --this.Indent;
        }
        if (contexts.size() > 0) {
            this.addln(")");
            ++this.Indent;
            this.print("context (");
            this.beginLineBreaking();
            for (i = 0; i < contexts.size(); ++i) {
                this.add("\"");
                this.add((String)contexts.elementAt(i));
                this.add("\"");
                if (i >= contexts.size() - 1) continue;
                this.add(", ");
            }
            this.endLineBreaking();
            --this.Indent;
        }
        this.addln(");");
        this.printOriginalName(operation);
        this.printAnnotations(operation, operation._beFullName);
    }

    protected void genStruct(StructNode struct, String declarator) {
        this.genUserComments(struct);
        this.print("struct ");
        this.add(struct._beName);
        this.addln(" {");
        ++this.Indent;
        if (this._forComments) {
            this.println("...");
        } else {
            Vector memberNames = struct._memberNames;
            Vector memberTypes = struct._memberTypes;
            int len = memberNames.size();
            for (int i = 0; i < len; ++i) {
                this.genMember(struct, (Type)memberTypes.elementAt(i), struct._repository._mapper.mapIdentifier((String)memberNames.elementAt(i)));
            }
        }
        this.printAnnotations(struct, null);
        --this.Indent;
        if (declarator == null) {
            this.println("};");
        } else {
            this.print("} ");
            this.add(declarator);
        }
    }

    protected void genType(Type type, String name) {
        this.genType(type, name, false, false);
    }

    protected void genType(Type type, String name, boolean needsDispatch, boolean beName) {
        block15: {
            Node node = (Node)((Object)type);
            int kind = node._kind;
            switch (kind) {
                case 15: {
                    SequenceNode sequence = (SequenceNode)type;
                    if (this.OutputAsHTML) {
                        this.add("sequence&lt");
                    } else {
                        this.add("sequence< ");
                    }
                    this.genType(sequence._type, null, needsDispatch, beName);
                    if (sequence._bound > 0) {
                        this.add(",".concat(String.valueOf(sequence._bound)));
                    }
                    if (this.OutputAsHTML) {
                        this.add("&gt");
                    } else {
                        this.add(" >");
                    }
                    if (name != null) {
                        this.add(" ");
                        this.add(name);
                    }
                    return;
                }
                case 16: {
                    ArrayNode array = (ArrayNode)type;
                    this.genType(array._type, String.valueOf(new StringBuffer(String.valueOf(name)).append("[").append(array._length).append("]")), needsDispatch, beName);
                    return;
                }
                case 14: 
                case 18: {
                    this.add(node.typeName());
                    break;
                }
                case 13: {
                    this.add(node.typeName());
                    if (name != null || ((PrimitiveNode)node)._pkind != 30000) break;
                    this.add(" ");
                    break;
                }
                default: {
                    if (node.isContained()) {
                        ContainedNode typeDefn = (ContainedNode)((Object)type);
                        if (needsDispatch) {
                            this.dispatch(typeDefn, "");
                            break;
                        }
                        if (beName) {
                            this.add(typeDefn._beName);
                            break;
                        }
                        this.add(typeDefn._beFullName);
                        break;
                    }
                    this._ER.internalError(String.valueOf(new StringBuffer("unknown or invalid type ").append(node.typeName()).append(" (").append(kind).append(") in IdlBackend.genType()")));
                }
            }
            if (name == null) break block15;
            this.add(" ");
            this.add(name);
        }
    }

    protected void genUnion(UnionNode union, String declarator) {
        this.genUserComments(union);
        this.print("union ");
        this.add(union._beName);
        this.add(" switch (");
        int _dkind = union._discriminator.kind();
        if (_dkind == 12 && ((EnumNode)union._discriminator)._container == union) {
            this.dispatch((EnumNode)union._discriminator, "");
        } else {
            this.genType(union._discriminator, null);
        }
        this.addln(") {");
        ++this.Indent;
        if (this._forComments) {
            this.println("...");
        } else {
            Vector memberTypes = union._memberTypes;
            Vector memberNames = union._memberNames;
            Vector memberLabels = union._memberLabels;
            int len = memberTypes.size();
            for (int i = 0; i < len; ++i) {
                if (i == union._defaultIndex) {
                    this.println("default:");
                }
                Vector labels = (Vector)memberLabels.elementAt(i);
                for (int j = 0; j < labels.size(); ++j) {
                    Object label = labels.elementAt(j);
                    this.print("case ");
                    if (_dkind == 12) {
                        this.add(((EnumNode)union._discriminator).toEnumName((String)label.toString())._beFullName);
                    } else {
                        this.add(union._discriminator.toLiteral(label));
                    }
                    this.addln(":");
                }
                if (i != memberNames.size() - 1 && memberNames.elementAt(i).equals(memberNames.elementAt(i + 1))) continue;
                ++this.Indent;
                this.genMember(union, (Type)memberTypes.elementAt(i), union._repository._mapper.mapIdentifier((String)memberNames.elementAt(i)));
                --this.Indent;
            }
        }
        this.printAnnotations(union, null);
        --this.Indent;
        if (declarator == null) {
            this.println("};");
        } else {
            this.print("} ");
            this.add(declarator);
        }
    }

    protected void genUserComments(ContainedNode node) {
        if (!this._forComments && this._options._comments && node._comment != null && node._comment.trim().length() > 0) {
            this.print("/*");
            this.add(node._comment);
            this.addln("*/");
        }
    }

    protected void genValue(ValueNode value) {
        String truncatable;
        this.genUserComments(value);
        if (value._custom) {
            this.print("custom valuetype ");
        } else if (value._abstract) {
            this.print("abstract valuetype ");
        } else {
            this.print("valuetype ");
        }
        this.add(value._beName);
        this.add(" ");
        String string = truncatable = value._truncatable ? "truncatable " : "";
        if (value._concreteBase != null || value._abstractBases.size() > 0) {
            this.add(": ");
            if (value._concreteBase != null) {
                this.add(truncatable);
                this.add(value._concreteBase._beFullName);
                if (value._abstractBases.size() > 0) {
                    this.add(", ");
                }
            }
            this.commaSepDefs(value._abstractBases, true);
        }
        if (value._supportedInterface != null || value._abstractInterfaces.size() > 0) {
            this.newLine();
            ++this.Indent;
            this.print("supports ");
            if (value._supportedInterface != null) {
                this.add(value._supportedInterface._beFullName);
                if (value._abstractInterfaces.size() > 0) {
                    this.add(", ");
                }
            }
            this.commaSepDefs(value._abstractInterfaces, true);
            --this.Indent;
        }
        this.addln(" {");
        ++this.Indent;
        this.printStylePragmas(value, false);
        if (this._forComments) {
            this.println("...");
        } else {
            this.genContents(value);
            Vector initNameList = value._initParamNames;
            Vector initTypeList = value._initParamTypes;
            for (int i = 0; i < value._initNames.size(); ++i) {
                String initName = (String)value._initNames.elementAt(i);
                Vector paramName = (Vector)initNameList.elementAt(i);
                Vector paramType = (Vector)initTypeList.elementAt(i);
                this.print(String.valueOf(new StringBuffer("factory ").append(initName).append("(")));
                for (int j = 0; j < paramName.size(); ++j) {
                    this.add("in ");
                    this.genType((Type)paramType.elementAt(j), value._repository._mapper.mapIdentifier((String)paramName.elementAt(j)));
                    if (j >= paramName.size() - 1) continue;
                    this.add(", ");
                }
                this.addln(");");
            }
        }
        this.printAnnotations(value, null);
        --this.Indent;
        this.println("};");
    }

    protected void genValueBox(ValueBoxNode valueBox) {
        this.genUserComments(valueBox);
        this.print("valuetype ");
        this.add(valueBox._beName);
        this.add(" ");
        this.genType(valueBox._type, null);
        this.addln(";");
        this.printAnnotations(valueBox, valueBox._beFullName);
    }

    protected void genValueMember(ValueMemberNode valueMember) {
        this.genUserComments(valueMember);
        if (valueMember._public) {
            this.print("public  ");
        } else {
            this.print("private ");
        }
        this.genType(valueMember._type, valueMember._beName);
        this.addln(";");
        this.printAnnotations(valueMember, valueMember._beFullName);
    }

    public static NodeFactory makeNodeFactory(ErrorReporter ER) {
        return new IdlNodeFactory(ER);
    }

    private String maybeOutputPragmas(ContainedNode def) {
        boolean OMGstyleName;
        if (this._forComments) {
            return null;
        }
        String repID = def._repId;
        String name = def._name;
        this._buf.reset();
        this._buf.append("IDL:");
        String s = (String)this._prefixStack.elementAt(0);
        this._buf.append(s);
        if (!s.equals("")) {
            this._buf.append('/');
        }
        this._buf.append(name);
        this._buf.append(":1.0");
        if (this._buf.equals(repID)) {
            return null;
        }
        String version = def._version;
        String versionString = ":".concat(String.valueOf(version));
        String customVersionRepID = String.valueOf(new StringBuffer("IDL:").append(this.prefix()).append(name).append(versionString));
        if (customVersionRepID.equals(repID)) {
            return String.valueOf(new StringBuffer("#pragma version ").append(name).append(" ").append(version));
        }
        boolean bl = OMGstyleName = repID.startsWith("IDL:") && repID.endsWith(versionString);
        if (OMGstyleName && repID.endsWith(String.valueOf(name).concat(String.valueOf(versionString)))) {
            String prefix = repID.substring(4, repID.lastIndexOf(String.valueOf(name).concat(String.valueOf(versionString))));
            if (prefix.length() > 0 && prefix.charAt(prefix.length() - 1) == '/') {
                this.prefixSet(prefix.substring(0, prefix.length() - 1));
            } else {
                this.prefixSet(prefix);
            }
            String defaultPrefix = this.defaultPrefix();
            if (!this._options._strict && prefix.equals(defaultPrefix)) {
                this.println("#pragma prefix");
            } else if (prefix.length() == 0) {
                this.println(String.valueOf(new StringBuffer("#pragma prefix \"").append(prefix).append("\"")));
            } else {
                this.println(String.valueOf(new StringBuffer("#pragma prefix \"").append(prefix.substring(0, prefix.length() - 1)).append("\"")));
            }
            return version.equals("1.0") ? null : String.valueOf(new StringBuffer("#pragma version ").append(name).append(" ").append(version));
        }
        String ret = String.valueOf(new StringBuffer("#pragma ID ").append(name).append(" \"").append(repID).append("\""));
        if (OMGstyleName && !version.equals("1.0")) {
            ret = String.valueOf(ret).concat(String.valueOf(String.valueOf(new StringBuffer("\n#pragma version ").append(name).append(" ").append(version))));
        }
        return ret;
    }

    protected void openModule(ModuleNode module) {
        if (!this._forComments) {
            this._modulePragmaVersionStack.push(this.maybeOutputPragmas(module));
            this.prefixPush(module._beName);
        }
        this.print("module ");
        this.add(module._beName);
        this.addln(" {");
        ++this.Indent;
        if (this._forComments) {
            this.println("...");
        }
    }

    private String prefix() {
        String s = (String)this._prefixStack.elementAt(0);
        return s.equals("") ? s : String.valueOf(s).concat("/");
    }

    private void prefixPop() {
        this._prefixStack.removeElementAt(0);
        this._defaultPrefixStack.removeElementAt(0);
    }

    private void prefixPush(String containerName) {
        String tmp = (String)this._prefixStack.elementAt(0);
        if (tmp.equals("")) {
            this._prefixStack.insertElementAt(containerName, 0);
        } else {
            this._prefixStack.insertElementAt(String.valueOf(new StringBuffer(String.valueOf(tmp)).append("/").append(containerName)), 0);
        }
        tmp = (String)this._defaultPrefixStack.elementAt(0);
        if (tmp.equals("")) {
            this._defaultPrefixStack.insertElementAt(containerName, 0);
        } else {
            this._defaultPrefixStack.insertElementAt(String.valueOf(new StringBuffer(String.valueOf(tmp)).append("/").append(containerName)), 0);
        }
    }

    private void prefixSet(String prefix) {
        if (prefix == null) {
            this._prefixStack.setElementAt(this._defaultPrefixStack.elementAt(0), 0);
        } else {
            this._prefixStack.setElementAt(prefix, 0);
        }
    }

    private void printAnnotations(ContainedNode def, String name) {
        if (def._annotations != null && def._annotations.size() > 0) {
            String preamble = name == null ? "#pragma hint " : String.valueOf(new StringBuffer("#pragma hint ").append(name).append(" "));
            this.printNameValuePairs(preamble, def._annotations);
            this.newLine();
        }
        if (def.hasFields()) {
            FieldNode node = (FieldNode)def;
            Vector v = node._memberAnnotations;
            if (v != null) {
                int len = v.size();
                for (int i = 0; i < len; ++i) {
                    Hashtable hashtable = (Hashtable)v.elementAt(i);
                    if (hashtable == null || hashtable.size() <= 0) continue;
                    this.printNameValuePairs(String.valueOf(new StringBuffer("#pragma hint .").append(node._memberNames.elementAt(i)).append(" ")), hashtable);
                    this.newLine();
                }
            }
        }
    }

    private void printNameValuePairs(String preamble, Hashtable hashtable) {
        this.ensureNewLine();
        StringTokenizer splitter = new StringTokenizer(this.expandAnnotations(hashtable), ",");
        this.print(preamble);
        this.add(splitter.nextToken().trim());
        while (splitter.hasMoreTokens()) {
            String next = splitter.nextToken().trim();
            if (this._horizPos + next.length() >= this._preferredLineWidth) {
                this.newLine();
                this.print(preamble);
                this.add(next);
                continue;
            }
            this.add(',');
            this.add(next);
        }
    }

    private void printOriginalName(AttributeNode attr, boolean setter) {
        if (setter) {
            if (attr._mutatorName == null) {
                return;
            }
            if (!"set_".concat(String.valueOf(attr._mutatorName)).equals(attr._name)) {
                this.println(String.valueOf(new StringBuffer("#pragma original_setter_name ").append(attr._beName).append(" \"").append(attr._mutatorName).append("\"")));
            }
        } else {
            if (attr._accessorName == null) {
                return;
            }
            if (!"get_".concat(String.valueOf(attr._accessorName)).equals(attr._name)) {
                this.println(String.valueOf(new StringBuffer("#pragma original_getter_name ").append(attr._beName).append(" \"").append(attr._accessorName).append("\"")));
            }
        }
    }

    private void printOriginalName(ExceptionNode ex, boolean defn) {
        if (ex._originalName != null && !ex._originalName.equals(ex._name)) {
            if (defn) {
                this.println(String.valueOf(new StringBuffer("#pragma original_name \"").append(ex._originalName).append("\"")));
            } else {
                this.println(String.valueOf(new StringBuffer("#pragma original_name ").append(ex._beName).append(" \"").append(ex._originalName).append("\"")));
            }
        }
    }

    private void printOriginalName(OperationNode op) {
        if (op._originalName != null && !op._originalName.equals(op._name)) {
            this.println(String.valueOf(new StringBuffer("#pragma original_name ").append(op._beName).append(" \"").append(op._originalName).append("\"")));
        }
    }

    private void printStylePragmas(InterfaceNode intrface, boolean forwardDecl) {
        if (intrface._pseudo) {
            this.println("#pragma pseudo ".concat(String.valueOf(intrface._beName)));
        }
    }

    private void printStylePragmas(ValueNode value, boolean forwardDecl) {
        if (value._pseudo) {
            this.println("#pragma pseudo ".concat(String.valueOf(value._beName)));
        }
    }
}

